# -*- encoding:UTF-8 -*-

import os
from PIL import Image, ImageDraw

#warning = input("WARNING! All manual, unregistered changes to default.json are going to be erased. Are you sure?")

start = """
{
    "providers": [
        {
            "type": "bitmap",
            "file": "minecraft:block/chiseled_quartz_block.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE000"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:item/ender_eye.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE001"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/slime_block.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE002"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/dark_oak_planks.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE003"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/mushroom_stem.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE004"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:item/redstone.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE005"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/red_mushroom_block.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE006"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/brown_mushroom_block.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE007"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/crying_obsidian.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE008"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/cobweb.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE009"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/coarse_dirt.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE010"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/ice.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE011"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/packed_ice.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE012"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/light_blue_terracotta.png",
            "ascent": 16,
            "height": 16,
            "chars": ["\\uE013"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:font/lever_stand.png",
            "ascent": 16,
            "height": 16,
            "chars": ["\\uE014"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/cyan_terracotta.png",
            "ascent": 16,
            "height": 16,
            "chars": ["\\uE015"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/red_terracotta.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE016"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/pink_terracotta.png",
            "ascent": 12,
            "height": 16,
            "chars": ["\\uE017"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/brown_concrete.png",
            "ascent": 16,
            "height": 16,
            "chars": ["\\uE018"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:block/purple_concrete.png",
            "ascent": 16,
            "height": 16,
            "chars": ["\\uE019"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:font/empty.png",
            "ascent": 9,
            "height": 9,
            "chars": ["\\uE020"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:font/venus.png",
            "ascent": 9,
            "height": 9,
            "chars": ["\\uE021"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:font/blank.png",
            "ascent": 2048,
            "height": 4096,
            "chars": ["\\uE022"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:font/white.png",
            "ascent": 2048,
            "height": 4096,
            "chars": ["\\uE023"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/border.png",
            "ascent": 78,
            "height": 93,
            "chars": ["\uE078"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/templates/background.png",
            "ascent": 78,
            "height": 93,
            "chars": ["\uE079"]
        }
        
        
        
        ,
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/x/-4.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE080"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/x/-3.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE081"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/x/-2.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE082"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/x/-1.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE083"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/x/0.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE084"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/x/1.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE085"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/x/2.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE086"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/x/3.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE087"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/x/4.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE088"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/y/0.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE090"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/y/1.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE091"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/y/2.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE092"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/y/3.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE093"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/y/4.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE094"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/y/5.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE095"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/y/6.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE096"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/y/7.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE097"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/y/8.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE098"]
        },
        {
            "type": "bitmap",
            "file": "minecraft:map/gen/coords/separator.png",
            "ascent": 93,
            "height": 108,
            "chars": ["\\uE099"]
        },\n

"""




path = "C:/Users/"+os.getenv('username')+"/AppData/Roaming/.minecraft/resourcepacks/ESCAPE THE LOST HALLS RESOURCEPACK/assets/minecraft/textures/map/"
default_json_path = "C:/Users/"+os.getenv('username')+"/AppData/Roaming/.minecraft/resourcepacks/ESCAPE THE LOST HALLS RESOURCEPACK/assets/minecraft/font/default.json"




#reset default.json and copy/paste the start json
#open(default_json_path, "w").close()
#
#with open(default_json_path, "a") as f:
#    f.write(start)






#this specifies the location of the icons in the icon atlas
icons = {"mask":(0, 0),"eye":(2, 0),"eye_north":(1, 2),"eye_south":(1, 3),"eye_east":(0, 3),"eye_west":(2, 3),"arrow_north":(1, 0),"arrow_south":(1, 1),"arrow_east":(0, 1),"arrow_west":(2, 1),"red_indicator_big":(3, 0),"red_indicator_small":(3, 1),"lever":(2, 2),"button":(3, 2)}

# bottom left coords: (-4, 0) ; top right coords: (4, 8).
# in pillow, top left is (0, 0).

previous_folder = ""
unicode_counter = 0
def combine(icon_name, coords, type, path_name = None):
    offset = [0, 0, 0, 0]

    #extract baground and icon
    background = Image.open(path + 'templates/sizer.png')
    size = background.size

    if type == "icon":
        folder = icon_name
        file_name = str(coords[0])+str(coords[1])
        atlas = Image.open(path + 'templates/icons.png')
        icon = atlas.crop((icons[icon_name][0]*9, icons[icon_name][1]*9, icons[icon_name][0]*9+9, icons[icon_name][1]*9+9))

        if icon_name == "mask":

            #hide or show branches, some rooms have some branches hidden until the room on the other side is uncovered
            if float(str(coords[0]) + '.' + str(coords[1])) in list(branches.keys()):
                room = branches[float(str(coords[0]) + '.' + str(coords[1]))]
                if "hide" in list(room.keys()): 
                    for direction in room["hide"]:
                        offset[["east","north","west","south"].index(direction)] -= 2
                if "show" in list(room.keys()):
                    for direction in room["show"]:
                        offset[["east","north","west","south"].index(direction)] += 2

            atlas = Image.open(path + 'templates/path/maze.png')
            icon = atlas.crop(((coords[0]+4)*9 + 6 - offset[0], (8 - coords[1])*9 + 6 - offset[1], (coords[0]+4)*9 + 6+9 + offset[2], (8 - coords[1])*9 + 6+9 + offset[3]))


        #create new image and merge them together
        new_im = Image.new('RGBA', size)
        new_im.paste(background, (0,0))
        new_im.paste(icon, ((coords[0]+4)*9 + 6 - offset[0], (8 - coords[1])*9 + 6 - offset[1]), icon)

        #create directory if it doesn't exist
        if not os.path.exists(path + 'gen/'+ icon_name):
            os.makedirs(path + 'gen/'+ icon_name)

    if type == "path":
        folder = "path"
        path_img = Image.open(path + 'templates/path/'+path_name+'.png')
        new_im = Image.new('RGBA', size)
        new_im.paste(background, (0,0))
        new_im.paste(path_img, (0,0), path_img)
    


    global unicode_counter
    global previous_folder

    unicode = 100
    if folder in common_rooms: 
        unicode += common_rooms.index(folder)*100

    else:
        print(previous_folder, folder)
        if previous_folder != folder:
            unicode_counter = 0

        if folder in list(special_rooms.keys()): 
            unicode += list(special_rooms.keys()).index(folder)*10
        else:
            unicode += len(list(special_rooms.keys()))*10

    if folder not in common_rooms:  
        unicode -= (x)*10 + y
        unicode += (len(common_rooms))*100

        unicode += unicode_counter
        unicode_counter += 1
        



    unicode += (x)*10 + y

    #with open(default_json_path, "a") as f:
    #    f.write("""
    #    {
    #        "type": "bitmap",
    #        "file": "minecraft:map/gen/"""+ folder + "/" + file_name +""".png",
    #        "ascent": 78,
    #        "height": 93,
    #        "chars": ["""+'"'+'\\'+'uE'+str(unicode)+'"'+"""]
    #    },\n"""
    #    )


    previous_folder = folder
    return new_im





special_rooms = {"red_indicator_big":[(-3, 3)], "red_indicator_small":[(-3, 3)], "lever":[(1, 6), (4, 5), (2, 0)], "button":[(-4, 5), (4, 1)]}
common_rooms = ["eye","arrow_north","arrow_south","arrow_east","arrow_west","mask"]
paths_img = ["maze","eye_path"]
branches = {-1.5: {"hide":["south"]}, -4.6: {"hide":["west"]}, -3.6: {"show":["east"]}, -1.4: {"show":["north","west","east","south"]}, -1.3: {"hide":["north","east"]}, -2.3: {"show":["west"]}, -1.0: {"hide":["east"]}, -2.0: {"show":["west"]}, -4.2: {"hide":["north"]}, -4.3: {"show":["south"]}, 0.4: {"hide":["east","west"]}, 1.4: {"show":["east"]}, 2.7: {"show":["west"]}}



#generate all the icons that need to be in every room

for name in common_rooms:
    for x in range(9):
        for y in range(9):

            combine(name, (x-4, y), "icon").save(path + 'gen/' + name + '/' + str(x-4)+str(y) + '.png')


#generate all the icons that need to be in specific rooms only

for name in special_rooms:
    for coords in special_rooms[name]:
        x, y = coords
        combine(name, (x, y), "icon").save(path + 'gen/' + name + '/' + str(x)+str(y) + '.png')


#generate the background with paths
for name in paths_img:
    combine(None, None, "path", name).save(path + 'gen/path/' + name + '.png')





























#close the default.json
#with open(default_json_path, "a") as f:
#    f.write("""
#        {
#            "type": "bitmap",
#            "file": "minecraft:font/bar.png",
#            "ascent": 8,
#            "height": 9,
#            "chars": ["\\uE800"]
#        },
#        {
#            "type": "bitmap",
#            "file": "minecraft:item/gravity/off.png",
#            "ascent": 8,
#            "height": 9,
#            "chars": ["\\uE801"]
#        },
#        {
#            "type": "bitmap",
#            "file": "minecraft:item/gravity/on.png",
#            "ascent": 8,
#            "height": 9,
#            "chars": ["\\uE802"]
#        }
#    ]
#}
#"""
#    )
